// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Ibscript.pas' rev: 10.00

#ifndef IbscriptHPP
#define IbscriptHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Sysutils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Ibdatabase.hpp>	// Pascal unit
#include <Ibcustomdataset.hpp>	// Pascal unit
#include <Ibsql.hpp>	// Pascal unit
#include <Ibdatabaseinfo.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Ibscript
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TIBParseKind { stmtDDL, stmtDML, stmtSET, stmtCONNECT, stmtDrop, stmtCREATE, stmtINPUT, stmtUNK, stmtEMPTY, stmtTERM, stmtERR, stmtCOMMIT, stmtROLLBACK, stmtReconnect, stmtRollbackSavePoint, stmtReleaseSavePoint, stmtStartSavepoint };
#pragma option pop

typedef void __fastcall (__closure *TIBSQLParseError)(System::TObject* Sender, AnsiString Error, AnsiString SQLText, int LineIndex);

typedef void __fastcall (__closure *TIBSQLExecuteError)(System::TObject* Sender, AnsiString Error, AnsiString SQLText, int LineIndex, bool &Ignore);

typedef void __fastcall (__closure *TIBSQLParseStmt)(System::TObject* Sender, TIBParseKind AKind, AnsiString SQLText);

class DELPHICLASS TIBScript;
typedef void __fastcall (__closure *TIBScriptParamCheck)(TIBScript* Sender, bool &Pause);

class DELPHICLASS TIBSQLParser;
class PASCALIMPLEMENTATION TIBSQLParser : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TIBSQLParseError FOnError;
	TIBSQLParseStmt FOnParse;
	Classes::TStrings* FScript;
	Classes::TStrings* FInput;
	AnsiString FTerminator;
	bool FPaused;
	bool FFinished;
	void __fastcall SetScript(const Classes::TStrings* Value);
	void __fastcall SetPaused(const bool Value);
	Classes::TStrings* FTokens;
	AnsiString FWork;
	int ScriptIndex;
	int LineIndex;
	int ImportIndex;
	bool InInput;
	AnsiString __fastcall TokenizeNextLine();
	TIBParseKind __fastcall IsValidStatement(void);
	void __fastcall RemoveComment(void);
	bool __fastcall AppendNextLine(void);
	void __fastcall LoadInput(void);
	
protected:
	virtual void __fastcall DoOnParse(TIBParseKind AKind, AnsiString SQLText);
	virtual void __fastcall DoOnError(AnsiString Error, AnsiString SQLText);
	void __fastcall DoParser(void);
	
public:
	__fastcall virtual TIBSQLParser(Classes::TComponent* AOwner);
	__fastcall virtual ~TIBSQLParser(void);
	void __fastcall Parse(void);
	__property int CurrentLine = {read=LineIndex, nodefault};
	__property Classes::TStrings* CurrentTokens = {read=FTokens};
	
__published:
	__property bool Finished = {read=FFinished, nodefault};
	__property bool Paused = {read=FPaused, write=SetPaused, nodefault};
	__property Classes::TStrings* Script = {read=FScript, write=SetScript};
	__property AnsiString Terminator = {read=FTerminator, write=FTerminator};
	__property TIBSQLParseStmt OnParse = {read=FOnParse, write=FOnParse};
	__property TIBSQLParseError OnError = {read=FOnError, write=FOnError};
};


class DELPHICLASS TIBScriptStats;
class PASCALIMPLEMENTATION TIBScriptStats : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	__int64 FBuffers;
	__int64 FReadIdx;
	__int64 FWrites;
	__int64 FFetches;
	__int64 FSeqReads;
	__int64 FReads;
	__int64 FDeltaMem;
	__int64 FStartBuffers;
	__int64 FStartReadIdx;
	__int64 FStartWrites;
	__int64 FStartFetches;
	__int64 FStartSeqReads;
	__int64 FStartReads;
	__int64 FStartingMem;
	Ibdatabase::TIBDatabase* FDatabase;
	Ibdatabaseinfo::TIBDatabaseInfo* FInfoStats;
	void __fastcall SetDatabase(const Ibdatabase::TIBDatabase* Value);
	__int64 __fastcall AddStringValues(Classes::TStrings* list);
	
public:
	__fastcall TIBScriptStats(void);
	__fastcall virtual ~TIBScriptStats(void);
	void __fastcall Start(void);
	void __fastcall Clear(void);
	void __fastcall Stop(void);
	__property Ibdatabase::TIBDatabase* Database = {read=FDatabase, write=SetDatabase};
	__property __int64 Buffers = {read=FBuffers};
	__property __int64 Reads = {read=FReads};
	__property __int64 Writes = {read=FWrites};
	__property __int64 SeqReads = {read=FSeqReads};
	__property __int64 Fetches = {read=FFetches};
	__property __int64 ReadIdx = {read=FReadIdx};
	__property __int64 DeltaMem = {read=FDeltaMem};
	__property __int64 StartingMem = {read=FStartingMem};
};


class PASCALIMPLEMENTATION TIBScript : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TIBSQLParser* FSQLParser;
	bool FAutoDDL;
	bool FStatsOn;
	Ibcustomdataset::TIBDataSet* FDataset;
	Ibdatabase::TIBDatabase* FDatabase;
	TIBSQLParseError FOnError;
	TIBSQLParseStmt FOnParse;
	Ibdatabase::TIBTransaction* FDDLTransaction;
	Ibdatabase::TIBTransaction* FTransaction;
	AnsiString FTerminator;
	Ibsql::TIBSQL* FDDLQuery;
	Ibsql::TIBSQL* FDMLQuery;
	bool FContinue;
	TIBSQLExecuteError FOnExecuteError;
	TIBScriptParamCheck FOnParamCheck;
	bool FValidate;
	bool FValidating;
	TIBScriptStats* FStats;
	int FSQLDialect;
	AnsiString FCharSet;
	TIBParseKind FCurrentStmt;
	bool FExecuting;
	bool __fastcall GetPaused(void);
	void __fastcall SetPaused(const bool Value);
	void __fastcall SetTerminator(const AnsiString Value);
	void __fastcall SetupNewConnection(void);
	void __fastcall SetDatabase(const Ibdatabase::TIBDatabase* Value);
	void __fastcall SetTransaction(const Ibdatabase::TIBTransaction* Value);
	AnsiString __fastcall StripQuote(const AnsiString Text);
	Classes::TStrings* __fastcall GetScript(void);
	void __fastcall SetScript(const Classes::TStrings* Value);
	Ibsql::TIBXSQLDA* __fastcall GetSQLParams(void);
	void __fastcall SetStatsOn(const bool Value);
	Classes::TStrings* __fastcall GetTokens(void);
	
protected:
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall DoDML(const AnsiString Text);
	virtual void __fastcall DoDDL(const AnsiString Text);
	virtual void __fastcall DoSET(const AnsiString Text);
	virtual void __fastcall DoConnect(const AnsiString SQLText);
	virtual void __fastcall DoCreate(const AnsiString SQLText);
	virtual void __fastcall DoReconnect(void);
	virtual void __fastcall DropDatabase(const AnsiString SQLText);
	void __fastcall ParserError(System::TObject* Sender, AnsiString Error, AnsiString SQLText, int LineIndex);
	void __fastcall ParserParse(System::TObject* Sender, TIBParseKind AKind, AnsiString SQLText);
	
public:
	__fastcall virtual TIBScript(Classes::TComponent* AOwner);
	__fastcall virtual ~TIBScript(void);
	bool __fastcall ValidateScript(void);
	void __fastcall ExecuteScript(void);
	Ibsql::TIBXSQLVAR* __fastcall ParamByName(AnsiString Idx);
	__property bool Paused = {read=GetPaused, write=SetPaused, nodefault};
	__property Ibsql::TIBXSQLDA* Params = {read=GetSQLParams};
	__property TIBScriptStats* Stats = {read=FStats};
	__property Classes::TStrings* CurrentTokens = {read=GetTokens};
	__property bool Validating = {read=FValidating, nodefault};
	
__published:
	__property bool AutoDDL = {read=FAutoDDL, write=FAutoDDL, default=1};
	__property Ibcustomdataset::TIBDataSet* Dataset = {read=FDataset, write=FDataset};
	__property Ibdatabase::TIBDatabase* Database = {read=FDatabase, write=SetDatabase};
	__property Ibdatabase::TIBTransaction* Transaction = {read=FTransaction, write=SetTransaction};
	__property AnsiString Terminator = {read=FTerminator, write=SetTerminator};
	__property Classes::TStrings* Script = {read=GetScript, write=SetScript};
	__property bool Statistics = {read=FStatsOn, write=SetStatsOn, default=1};
	__property TIBSQLParseStmt OnParse = {read=FOnParse, write=FOnParse};
	__property TIBSQLParseError OnParseError = {read=FOnError, write=FOnError};
	__property TIBSQLExecuteError OnExecuteError = {read=FOnExecuteError, write=FOnExecuteError};
	__property TIBScriptParamCheck OnParamCheck = {read=FOnParamCheck, write=FOnParamCheck};
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Ibscript */
using namespace Ibscript;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Ibscript
